<?php

namespace App\Http\Controllers\Customers;
use App\Http\Controllers\Controller;
use App\Http\Requests\Customers\AddTherapistReviewRequest;
use App\Http\Requests\Customers\AddTherapistCommunityReviewRequest;

class ReviewsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
    //   $this->middleware('customer');
  }


  public function addTherapistReview(AddTherapistReviewRequest $request)
  {
      $user = auth()->user();
      $customer = $user->customer;
      if($customer){
          $customer->therapist_reviews()->create($request->all());
      }
      request()->session()->flash('alert', [
          'type' => 'success',
          'message' => 'Review Added Successfully',
      ]);
      return redirect()->back()->withResponseData([
          'message' => 'Review Added Successfully',
          'type' => 'success'
      ]);
  }
  public function addTherapistCommunityReview(AddTherapistCommunityReviewRequest $request)
  {
      $user = auth()->user();
      $customer = $user->customer;
      if($customer){
          $customer->therapist_community_reviews()->create($request->all());
      }
      request()->session()->flash('alert', [
          'type' => 'success',
          'message' => 'Review Added Successfully',
      ]);
      return redirect()->back()->withResponseData([
          'message' => 'Review Added Successfully',
          'type' => 'success'
      ]);
  }
}
